;*************************************************************************
; DESCRIBTION :	THIS PROGRAM IS ROTATE RIGHT FOR PORT 3 OF AT89C5131
; FILE NAME   : JR51USB-tester.ASM
; COMPILER    : CROSS 32
; SUPPORT     : AT89C5131
; X'TAL	      : 24MHz
; BAUD RATE   : 115200bps
; DATE        : 6 SEPTEMBER 2004
; MODE	      : UART MODE1 INTERNAL BAUD RATE GENERATOR,NO USED INTERRUPT.
;*************************************************************************

	CPU	"8051.TBL"	; Processor declaration
	HOF	"INT8"		; Intel 8-bit hexcode
	INCL    "AT89C5131.SFR" 

;*********************************************************************
;	ADDRESS DEFINE SECTION
;*********************************************************************
BUFFER_RX	EQU	70H
COUNT_RX	EQU	6FH
OUT_RX_DEL	EQU	6EH
;*********************************************************************
;*********************************************************************
;	DEFINE BYTE SECTION
;*********************************************************************
; ADDRESS 20H USED FOR BIT ADDRESSABLE ONLY.
SLAVE_ADR	EQU	21H
ADR_H		EQU	22H
ADR_L		EQU	23H
B_TWI_BUSY	EQU	25H	; BIT TYPE
TWI_DATA_I	EQU	26H
STOP_BACKUP	EQU	27H
TWI_DATA	EQU	28H
HEX2IN		EQU	30H
ASC_L		EQU	31H
ASC_H		EQU	32H
DIRECTION	EQU	33H	; 01H = WRITING, 02H = READING
IE		EQU    0A8H
N		EQU	34H
ERR_TWI		EQU	35H
SDATA		EQU	00H	; # ADJ BY USER***( DATA )
SEC		EQU	40H
SEC_R		EQU	41H
TWI_DIR		EQU	42H

;*********************************************************************
;		DEFINE BIT SECTION
;*********************************************************************
RW		EQU	00H	; 0=WRITE, 1=READ  ; BIT TYPE
CHECK_COM	EQU	01H	; 
;*********************************************************************

		ORG	0000H		; Reset vector
START:		LJMP	BEGIN

;************************************************
;		INTERRUPT SECTION
;************************************************
		ORG	0003H
		LCALL	INT0_ROUT
		RETI

;************************************************
;		INTERRUPT SECTION
;************************************************
		ORG	0043H
		LJMP	TWI_IT

;************************************************

		ORG	0100H
		
BEGIN:		MOV     SP,#256-32              ; define stack = 32 byte
;*************************************************
;		UART 115200bps
;*************************************************
		ORL	CKCON0,#00000001B	; 6 CLK PERIOD/MACHINE
		ORL	PCON,#11000000B		; ENABLE THE FRAMING BIT ERROR DETECTION, DOUBLE BAUD RATE
						; AND CHECK FE BIT OF SCON SFR
		ORL	BDRCON,#00001110B	; SPD=1,RBCK =1, TBCK =1
		MOV	SCON,#01010000B		; uart in mode 1 (8 bit), REN=1 
		MOV	BRL,#243		; U CAN SEE THIS VALUE FROM PAGE 71 OF DATASHEET
		ORL	BDRCON,#00010000B	; BRR = 1 , START BAUD RATE RUN

		;========================
		; TRANSMITION PAGE 1
		;========================
FIRST_P:	MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_1
		LCALL	TRANSMIT

		MOV	DPTR,#TEXT_1
		LCALL	TRAN_DELAY

		;========================
		; WAIT RECEIVE 1 KEY.
		;========================
WAIT_P1:	LCALL	KEEP_A_KEY

		;************************
		; COMPARE KEY	; FIND ENTER KEY
		;========================
		CJNE	A,#0DH,WAIT_P1
		;************************
		
		;========================
		; TRANSMITION PAGE 2
		;========================
MAIN_P:		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_2
		LCALL	TRANSMIT

;===============;============================================
		; WAIT RECEIVE 1 KEY.
		;========================
KEEP_MAIN:	LCALL	KEEP_A_KEY

		;************************
		; COMPARE KEY	
		;========================
CHOOSE1:	CJNE	A,#31H,CHOOSE2		; FIND KEY 1
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_PORT0
		LCALL	TRANSMIT

			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
START_P0:		MOV	A,#0FEH		; DEFIND FIRST VALUE     
LOOP_P0:		RR	A
			MOV	P0,A
			lCALL	DELAY_100ms

			LCALL	DELAY_RX_L
			MOV	R0,OUT_RX_DEL
			CJNE	R0,#1BH,LOOP_P0

			LJMP	MAIN_P	
			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB

;===============;============================================
CHOOSE2:	CJNE	A,#32H,CHOOSE3		; FIND KEY 2
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_PORT1
		LCALL	TRANSMIT
		
			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
START_P1:		MOV	A,#0FEH		; DEFIND FIRST VALUE     
LOOP_P1:		RR	A
			MOV	P1,A
			lCALL	DELAY_100ms

			LCALL	DELAY_RX_L
			MOV	R0,OUT_RX_DEL
			CJNE	R0,#1BH,LOOP_P1	;FIND ESC KEY

			LJMP	MAIN_P	
			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
;===============;============================================
CHOOSE3:	CJNE	A,#33H,CHOOSE4		; FIND KEY 3
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_PORT2
		LCALL	TRANSMIT
		
			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
START_P2:		MOV	A,#0FEH		; DEFIND FIRST VALUE     
LOOP_P2:		RR	A
			MOV	P2,A
			lCALL	DELAY_100ms

			LCALL	DELAY_RX_L
			MOV	R0,OUT_RX_DEL
			CJNE	R0,#1BH,LOOP_P2	;FIND ESC KEY

			LJMP	MAIN_P	
			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
;===============;============================================
CHOOSE4:	CJNE	A,#34H,CHOOSE5		; FIND KEY 4
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_PORT3
		LCALL	TRANSMIT

			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
START_P3:		MOV	A,#0FEH		; DEFIND FIRST VALUE     
LOOP_P3:		RR	A
			MOV	P3,A
			lCALL	DELAY_100ms

			LCALL	DELAY_RX_L
			MOV	R0,OUT_RX_DEL
			CJNE	R0,#1BH,LOOP_P3	;FIND ESC KEY

			LJMP	MAIN_P	
			;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
;===============;============================================
CHOOSE5:	CJNE	A,#35H,CHOOSE6	; FIND KEY 5
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_INT0
		LCALL	TRANSMIT
		
		;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
		SETB	P3.2
		MOV	IEN0,#81H	; ENABLE INTERRUPT
		SETB	IT0		; FALLING EDGE

LOOP_INT0:	LCALL	DELAY_RX_L
		MOV	R0,OUT_RX_DEL
		CJNE	R0,#1BH,LOOP_INT0;FIND ESC KEY
		;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
		LJMP	MAIN_P
;===============;============================================
CHOOSE6:	CJNE	A,#36H,CHOOSE7_BACKUP		; FIND KEY 6
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_EEPROM
		LCALL	TRANSMIT
		
		;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB

;*************************************************
;		UART 115200bps
;*************************************************
BEGIN_W:	;ORL	CKCON0,#00000001B	; 6 CLK PERIOD/MACHINE
		;ORL	PCON,#11000000B		; ENABLE THE FRAMING BIT ERROR DETECTION, DOUBLE BAUD RATE
						; AND CHECK FE BIT OF SCON SFR
		;ORL	BDRCON,#00001110B	; SPD=1,RBCK =1, TBCK =1
		;MOV	SCON,#01010000B		; uart in mode 1 (8 bit), REN=1 
		;MOV	BRL,#243		; U CAN SEE THIS VALUE FROM PAGE 71 OF DATASHEET
		;ORL	BDRCON,#00010000B	; BRR = 1 , START BAUD RATE RUN
		;CLR     ES
		;CLR     EA
;*************************************************		
;		INITIALIZE EEPROM 24XX256 WRITE
;*************************************************		
		ORL	CKCON0,#00000001B	; 6 CLK PERIOD/MACHINE
		ORL	SSCON,#01000000B	; enable TWI */
		ANL	SSCON,#01000100B	; 
		SETB	EA			; interrupt enable */
		ORL	IEN1,#02h		; enable TWI interrupt */
		CLR	B_TWI_BUSY
		MOV	TWI_DATA,#SDATA		; data example to send */**
		MOV	ADR_H,#00H
		MOV	ADR_L,#00H
		MOV	STOP_BACKUP,#00H
		MOV	DIRECTION,#01H
		MOV	TWI_DIR,#01H
		SETB	CHECK_COM
		MOV	N,#0FFH
		MOV	R0,#00H
		MOV	P0,#0FH

LOOP_W:		JNB	CHECK_COM,ERR_TWI_T	; FIND ERROR ,THERE ARE =JUMP .

		MOV	ACC,STOP_BACKUP		; FIND STOP BIT, IF '1' JUMP
		JB	ACC.4,CONT_W

		JB	B_TWI_BUSY,END_IF_W	; jump if b_TWI_busy bit = '1'*/
		MOV	ACC,SSCON
		JB	ACC.4,END_IF_W		; jump if acc.4 bit = '1' "STOP FLAG"
						; usually not jump*/
		SETB	B_TWI_BUSY		; flag busy =1 , now, I'm not Empty.*/
		MOV	SLAVE_ADR,#10100000B	; slave adresse example 
		CLR	RW			; 0= WRITE
		MOV	SSDAT,#00h		; clear buffer before sending data
		ORL	SSCON,#00100000B	; TWI start sending */ after that SI bit is set '1'
						; and  the status code in SSCS will be 08h.
		JMP	LOOP_W

		; BBBBBBB  BACKUP BBBBBB
CHOOSE7_BACKUP:	LJMP	CHOOSE7
		; BBBBBBBBBBBBBBBBBBBBBB

; ************************************************
CONT_W:		MOV	STOP_BACKUP,#00H
		INC	ADR_L
		INC	TWI_DATA
		INC	R0

		CJNE	R0,#00H,LOOP_W		; 0 - 255h
		MOV	P0,#55H
		SJMP	BEGIN_R
END_IF_W:	JMP	LOOP_W
; ************************************************
ERR_TWI_T:	;==================
		;  CLEAR DISPLAY
		;==================
		MOV	A,#0CH			; "CLEAR DISPLAY"
		LCALL	TX_BYTE

		;==================
		;  MASSAGE
		;==================
		MOV	DPTR,#SHOW_ERR_TWI
		LCALL	TRANSMIT
		LJMP	ESC_AG6
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;*************************************************		
;		INITIALIZE EEPROM 24XX256 READ
;*************************************************
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;*************************************************
;		UART 115200bps
;*************************************************
BEGIN_R:	
		;==================
		;  CLEAR DISPLAY
		;==================
		;MOV	A,#0CH			; "CLEAR DISPLAY"
		;LCALL	TX_BYTE

		;==================
		;  MASSAGE
		;==================
		MOV	DPTR,#SHOW1
		LCALL	TRANSMIT

;*************************************************		
;		INITIALIZE EEPROM 24XX256
;*************************************************		
		ORL	SSCON,#40h		; enable TWI */
		SETB	EA			; interrupt enable */
		ORL	IEN1,#02h		; enable TWI interrupt */
		CLR	B_TWI_BUSY
		;MOV	TWI_DATA,#00H		; data example to send
		MOV	DIRECTION,#02H
		MOV	STOP_BACKUP,#00H
		MOV	ADR_H,#00h
		MOV	ADR_L,#00h
		MOV	R0,#00H
		;MOV	N,#00H

;================================================
;		READ EEPROM 24XX256
;================================================
LOOP_R:		MOV	ACC,STOP_BACKUP	

		JB	ACC.4,CONT_R		; FIND STOP BIT, IF '1' JUMP

		JB	B_TWI_BUSY,END_IF_BA	; jump if b_TWI_busy bit = '1'*/
		MOV	ACC,SSCON
		JB	ACC.4,END_IF_BA		; jump if acc.4 bit = '1' "STOP BIT"
						; usually not jump*/
		SETB	B_TWI_BUSY		; flag busy =1 , now, I'm not Empty.*/
		MOV	SLAVE_ADR,#10100000B	; slave adresse example 
		CLR	RW			; 0=write 
		MOV	SSDAT,#00h		; clear buffer before sending data

		;=============
START_R:	ORL	SSCON,#20h		; TWI start sending */ after that SI bit is set to '1'
						; and  the status code in SSCS will be 08h.
		JMP	LOOP_R

;================================================
END_IF_BA:	LJMP	END_IF_R
;================================================
;		DISPLAY TO LED
;================================================
CONT_R:		MOV	STOP_BACKUP,#00H
		
		;MOV	A,TWI_DATA_I
		;CJNE	A,00H,ERROR_R		; R0 =ADD 00H

		MOV	HEX2IN,TWI_DATA_I
		LCALL	DELAYS_TWI		; JUST HAVE
		LCALL	HEX2ASC2		; OUTPUT STAY IN "ASC_L","ASC_H"

		MOV	A,ASC_H
		LCALL   TX_BYTE

		MOV	A,ASC_L
		LCALL	TX_BYTE
		
		MOV	A,#48H			; "H"
		LCALL	TX_BYTE

		MOV	A,#20H			; "Space"
		LCALL	TX_BYTE

C_R:		INC	ADR_L
		INC	R0


		CJNE R0,#00H,LOOP_R		; amount = 256, rang = 0 - 255

		;==================
		;  MASSAGE
		;==================
		MOV	DPTR,#ENTER		; ENTER
		LCALL	TRANSMIT

		MOV	DPTR,#ENTER		; ENTER
		LCALL	TRANSMIT

		MOV	DPTR,#SHOW2
		LCALL	TRANSMIT

EETWI:		
			PUSH	ACC
			MOV	ACC,R0
			PUSH	ACC

			MOV	R0,#4
TWI_RX:			MOV	DPTR,#TEXT_INT0
			LCALL	TRANSMIT
			LCALL	DELAY_1S

			MOV	DPTR,#BACK6
			LCALL	TRANSMIT

			MOV	DPTR,#SPACE6
			LCALL	TRANSMIT
			LCALL	DELAY_1S
			LCALL	DELAY_100MS

			MOV	DPTR,#BACK6
			LCALL	TRANSMIT
			
			DJNZ	R0,TWI_RX

			MOV	DPTR,#TEXT_INT0
			LCALL	TRANSMIT

			POP	ACC
			MOV	R0,ACC
			POP	ACC

		Ljmp	ESC_AG6			; XXXXX

;----------------------------------------
END_IF_R:	LJMP	LOOP_R			

; ************************************************
		;BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB

		;========================
		; FIND ESC KEY
		;========================
ESC_AG6:	LCALL	KEEP_A_KEY
		;************************
		; COMPARE KEY	
		;========================
		CJNE	A,#1BH,ESC_AG6		; FIND ESC
		;************************
		LJMP	MAIN_P
;===============;============================================
CHOOSE7:	CJNE	A,#37H,CHOOSE8_BA	; FIND KEY 7 ( DS1307 )
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_DS1307
		LCALL	TRANSMIT
		
		MOV	TWI_DIR,#02H

		; BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
;*************************************************
;		UART 115200bps
;*************************************************
BEGIN_W7:	ORL	CKCON0,#00000001B	; 6 CLK PERIOD/MACHINE
		ORL	PCON,#11000000B		; ENABLE THE FRAMING BIT ERROR DETECTION, DOUBLE BAUD RATE
						; AND CHECK FE BIT OF SCON SFR
		ORL	BDRCON,#00001110B	; SPD=1,RBCK =1, TBCK =1
		MOV	SCON,#01010000B		; uart in mode 1 (8 bit), REN=1 
		MOV	BRL,#243		; U CAN SEE THIS VALUE FROM PAGE 71 OF DATASHEET
		ORL	BDRCON,#00010000B	; BRR = 1 , START BAUD RATE RUN
		CLR     ES
		CLR     EA
;*************************************************		
;		INITIALIZE DS1307
;*************************************************		
		ORL	CKCON0,#00000001B	; 6 CLK PERIOD/MACHINE
		ORL	SSCON,#01000000B	; enable TWI */
		ANL	SSCON,#01000100B	; 
		SETB	EA			; interrupt enable */
		ORL	IEN1,#02h		; enable TWI interrupt */
		CLR	B_TWI_BUSY
		MOV	ADR_L,#00H
		MOV	SEC,#00H
		MOV	STOP_BACKUP,#00H
		MOV	DIRECTION,#01H
		;MOV	R0,#00H
		MOV	P1,#0FH

LOOP_W7		MOV	ACC,STOP_BACKUP		; FIND STOP BIT, IF '1' JUMP
		JB	ACC.4,CONT_W7

		JB	B_TWI_BUSY,END_IF_W7	; jump if b_TWI_busy bit = '1'*/

		MOV	ACC,SSCON
		JB	ACC.4,END_IF_W7		; jump if acc.4 bit = '1' "STOP FLAG"
						; usually not jump*/
		SETB	B_TWI_BUSY		; flag busy =1 , now, I'm not Empty.*/
		MOV	SLAVE_ADR,#11010000B	; slave adresse example 
		CLR	RW			; 0= WRITE
		MOV	SSDAT,#00h		; clear buffer before sending data
		ORL	SSCON,#00100000B	; TWI start sending */ after that SI bit is set '1'
						; and  the status code in SSCS will be 08h.

		JMP	LOOP_W7
; *********************************
;		BACKUP
; *********************************
CHOOSE8_BA:	LJMP	CHOOSE8
; ************************************************
CONT_W7:		
		MOV	P1,#55H
		LJMP	BEGIN_R7
END_IF_W7:	JMP	LOOP_W7

;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
;*************************************************		
;		INITIALIZE DS1307 READ
;*************************************************
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
BEGIN_R7:	
;*************************************************		
;		INITIALIZE DS1307
;*************************************************		
		ORL	SSCON,#40h			; enable TWI */
		SETB	EA				; interrupt enable */
		ORL	IEN1,#02h			; enable TWI interrupt */
		CLR	B_TWI_BUSY
		MOV	TWI_DATA,#00H			; data example to send
		MOV	DIRECTION,#02H
		MOV	STOP_BACKUP,#00H
		MOV	ADR_L,#00h
		MOV	P2,#03H

;================================================
;		READ DS1307
;================================================
LOOP7:		MOV	ACC,STOP_BACKUP		
		JB	ACC.4,CONT7		; FIND STOP BIT, IF '1' JUMP

		JB	B_TWI_BUSY,END_IF7	; jump if b_TWI_busy bit = '1'*/

		MOV	ACC,SSCON
		JB	ACC.4,END_IF7		; jump if acc.4 bit = '1' "STOP BIT"
						; usually not jump*/
		SETB	B_TWI_BUSY		; flag busy =1 , now, I'm not Empty.*/
		MOV	SLAVE_ADR,#11010000B	; slave adresse example 
		CLR	RW			; 0=write 
		MOV	SSDAT,#00h		; clear buffer before sending data

		;=============
		ORL SSCON,#20h			; TWI start sending */ after that SI bit is set '1'
						; and  the status code in SSCS will be 08h.

		JMP	LOOP7
;================================================
;		DISPLAY TO LED
;================================================
CONT7:		MOV	STOP_BACKUP,#00H

		MOV	HEX2IN,SEC_R
		LCALL	DELAYS_TWI		; JUST HAVE
		LCALL	HEX2ASC2		; OUTPUT STAY IN "ASC_L","ASC_H"

		MOV	A,ASC_H
		LCALL   TX_BYTE

		MOV	A,ASC_L
		LCALL	TX_BYTE

		LCALL	DELAY_100MS		; ????????

		MOV	A,#08H
		LCALL	TX_BYTE

		MOV	A,#08H
		LCALL	TX_BYTE
	
		MOV	P2,#18H

		LCALL	DELAY_RX_LS
		MOV	R0,OUT_RX_DEL
		CJNE	R0,#1BH,LOOP7

		LJMP	MAIN_P

END_IF7:		
		LJMP LOOP7

		; BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB

;===============;============================================
CHOOSE8:	CJNE	A,#38H,CHOOSE9		; FIND KEY 8
		;************************
		MOV	DPTR,#CLEAR
		LCALL	TRANSMIT

		MOV	DPTR,#PAGE_PCF8574
		LCALL	TRANSMIT

		MOV	TWI_DIR,#03H
		
		; BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
;*************************************************		
;		INITIALIZE PCF8574A
;*************************************************		
BEGIN_PCF:	ORL	CKCON0,#00000001B	; 6 CLK PERIOD/MACHINE
		ORL	SSCON,#01000000B	; enable TWI */
		ANL	SSCON,#01000100B	; 
		SETB	EA			; interrupt enable */
		ORL	IEN1,#02h		; enable TWI interrupt */
		CLR	B_TWI_BUSY
		MOV	TWI_DATA,#80H		; data example to send */**
		MOV	ADR_H,#00H
		MOV	ADR_L,#00H
		MOV	STOP_BACKUP,#00H
		MOV	R0,#00H
		MOV	P0,#0FH

LOOP_W_PCF:	MOV	ACC,STOP_BACKUP		; FIND STOP BIT, IF '1' JUMP
		JB	ACC.4,CONT_W_PCF

		JB	B_TWI_BUSY,END_IF_W_PCF	; jump if b_TWI_busy bit = '1'*/
		MOV	ACC,SSCON
		JB	ACC.4,END_IF_W_PCF	; jump if acc.4 bit = '1' "STOP FLAG"
						; usually not jump*/
		SETB	B_TWI_BUSY		; flag busy =1 , now, I'm not Empty.*/
		MOV	SLAVE_ADR,#01110000B	; slave adresse example 
		CLR	RW			; 0= WRITE
		MOV	SSDAT,#00h		; clear buffer before sending data
		ORL	SSCON,#00100000B	; TWI start sending */ after that SI bit is set '1'
						; and  the status code in SSCS will be 08h.

		JMP	LOOP_W_PCF
; ************************************************
CONT_W_PCF:	MOV	STOP_BACKUP,#00H
		MOV	P0,#55H
		
		PUSH	ACC
		MOV	A,TWI_data
		RL	A
		MOV	TWI_DATA,A
		POP	ACC

		LCALL DELAY_1S

		LCALL	DELAY_RX_LS
		MOV	R0,OUT_RX_DEL
		CJNE	R0,#1BH,LOOP_W_PCF

		LJMP	MAIN_P
		;LJMP	LOOP_W_PCF

END_IF_W_PCF:	JMP	LOOP_W_PCF

		; BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB

;===============;============================================
CHOOSE9:	CJNE	A,#1BH,ERRO		; FIND ESC
		;************************
		LJMP	FIRST_P
;===============;============================================

		JMP	$
;*************************************************************************************************************************************
;		%
;		%
;		%
	; #####################################
	;	MESSAGE ERROR
	; #####################################
ERRO:		MOV	DPTR,#TEXT_ERR1
		LCALL	TRAN_DELAY
		
		MOV	R0,#5
L_DE		LCALL	DELAY_1S
		DJNZ	R0,L_DE

		MOV	R0,#35			; DECIMAL
L_E		MOV	DPTR,#BACKSPACE
		LCALL	TRANSMIT
		DJNZ	R0,L_E

		LJMP	KEEP_MAIN
	; #####################################
;********************** ROUTINE: INT 0 **************************************
;			INPUT : -		; DEFINE TEXT LOCATION
;			OUTPUT : -			
;****************************************************************************
INT0_ROUT:		PUSH	ACC
			MOV	ACC,R0
			PUSH	ACC

			MOV	R0,#4
INT_R:			MOV	DPTR,#TEXT_INT0
			LCALL	TRANSMIT
			LCALL	DELAY_1S

			MOV	DPTR,#BACK6
			LCALL	TRANSMIT

			MOV	DPTR,#SPACE6
			LCALL	TRANSMIT
			LCALL	DELAY_1S
			LCALL	DELAY_100MS

			MOV	DPTR,#BACK6
			LCALL	TRANSMIT
			
			DJNZ	R0,INT_R

			MOV	DPTR,#TEXT_INT0
			LCALL	TRANSMIT

			POP	ACC
			MOV	R0,ACC
			POP	ACC
			RET
;		
;********************** ROUTINE: TX *****************************************
;			INPUT : DPTR		; DEFINE TEXT LOCATION
;			OUTPUT : -			
;****************************************************************************
TRANSMIT:	CLR	TI			; Clear TI
TX_LOOP:	CLR	A			; Clear ACC.
		MOVC	A,@A+DPTR		; Get Data from ROM with Pointer
		INC	DPTR			; Increase Pointer
		CJNE	A,#0FFH,TX_CHAR		; Check 0FFH End of Text Char.
		RET				; End => Return

TX_CHAR:	MOV	SBUF,A			; Send Data to SBUF
		JNB	TI,$			; Wait until TX already (TI=1)
		CLR	TI			; Clear TI
		AJMP	TX_LOOP			; Jump to TX_LOOP

;********************** ROUTINE: RX *****************************************
;			INPUT : R0		; DEFINE BUFFER ADDRESS
;			OUTPUT : ADDRESS 70H....			
;****************************************************************************

RECEIVE:	SETB	REN			; Set RX Enable
RE_LOOP:	JNB	RI,$			; Wait received 1 byte FROM KEY BOARD[ JUMP IF BIT RI = '0']
		CLR	RI			; CLEAR RECEIVE INTERRUPT FLAG
;		****************************
;		FRAMEING BIT ERROR DETECTION
;		****************************
		MOV	ACC,SCON
		CLR	SCON.7
		JB	ACC.7,RE_LOOP		; JUMP IF SCON.7(FE) = '1'
;		****************************
		MOV	A,SBUF			; Get byte from SBUF
		MOV	@R0,A			; KEEP 1 BYTE DATA TO MEMORY 70H
		CJNE	A,#0DH,INC_R0		; Check Enter key receive? [IF REG "A" UNEQUAL 0DH JUMP]
		RET
;		************************
;		COUNT THE AMOUNT WORDS
;		************************
INC_R0:		INC	R0			; Increase pointer
		AJMP	RE_LOOP			; Back to do loop

;********************** ROUTINE: TX_DE **************************************
;			INPUT : DPTR		; DEFINE TEXT LOCATION
;			OUTPUT : -			
;****************************************************************************
TRAN_DELAY:	CLR	TI			; Clear TI
TX_LOOP_D:	CLR	A			; Clear ACC.
		MOVC	A,@A+DPTR		; Get Data from ROM with Pointer
		INC	DPTR			; Increase Pointer
		CJNE	A,#0FFH,TX_CHAR_D	; Check 0FFH End of Text Char.
		RET				; End => Return

TX_CHAR_D:	MOV	SBUF,A			; Send Data to SBUF
		JNB	TI,$			; Wait until TX already (TI=1)
		CLR	TI			; Clear TI
		LCALL	DELAY_60mS			; 
		AJMP	TX_LOOP_D		; Jump to TX_LOOP

;********************** ROUTINE: KEEP A KEY *********************************
;			INPUT : -			; DEFINE BUFFER ADDRESS
;			OUTPUT : Acc			
;****************************************************************************
KEEP_A_KEY:	SETB	REN
		JNB	RI,$
		CLR	RI
		MOV	A,SBUF
		RET

;******************************************************
;*                Send 1-Byte to SERIAL               *
;*                Input   : ACC                       *
;*                Output  : Serial port               *
;******************************************************
TX_BYTE:    ;LCALL	DELAY			; JUST HAVE
            CLR    TI
            MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            RET

;******************************************************
;		CONVERT HEX 1 DIGIT TO ASCII CODE
;		INPUT : A
;		OUTPUT : A
;******************************************************
HEX2ASC1:	PUSH	ACC
		CLR	C
		SUBB	A,#0AH
		POP	ACC
		JC	L_CON
		ADD	A,#7
L_CON:		ADD	A,#30H
		RET

;******************************************************
;		CONVERT HEX 2 DIGIT TO ASCII CODE
;		INPUT : HEX2IN
;		OUTPUT : ASC_L
;		OUTPUT : ASC_H
;******************************************************
HEX2ASC2:	MOV	A,HEX2IN
		ANL	A,#0FH
		LCALL	HEX2ASC1
		MOV	ASC_L,A
		MOV	A,HEX2IN
		SWAP	A
		ANL	A,#0FH
		LCALL	HEX2ASC1
		MOV	ASC_H,A
		RET

; ************************************************
;		SEND ENTER 
; ************************************************
ENTER:		DFB	0AH,0DH,0FFH

; ************************************************
;		CLEAR DISPLAY 
; ************************************************
CLEAR:		DFB	0CH,0FFH

; ************************************************
;		BACKSPACE
; ************************************************
BACKSPACE:	DFB	08H,0FFH

; ************************************************
;		UP  
; ************************************************
UP:		DFB	09H,0FFH

; ************************************************
;		LEFT <--
; ************************************************
LEFT:		DFB	019H,0FFH

; ************************************************
;		BACK 6 CHAR
; ************************************************
BACK6:		DFB	08H,08H,08H,08H,08H,08H,0FFH

; ************************************************
;		SENT SPACE 6 CHAR
; ************************************************
SPACE6:		DFB	2EH,2EH,2EH,2EH,2EH,2EH,0FFH

; ************************************************
;		DELAY  
; ************************************************
DELAY:		MOV	R7,#50
D1:		MOV	R6,#50
D2:		NOP
		NOP	
		DJNZ	R6,D2
		DJNZ	R7,D1
		RET

; ************************************************
;		DELAY 60ms (AT 12CLK/MACHINE)
; ************************************************
DELAY_60mS:	MOV	R7,#3
D60MS1:		MOV	R6,#100
D60MS2:		MOV	R5,#100
D60MS3:		NOP
		NOP
		DJNZ	R5,D60MS3
		DJNZ	R6,D60MS2
		DJNZ	R7,D60MS1
		RET

; ************************************************
;		DELAY 100ms (AT 12CLK/MACHINE)
; ************************************************
DELAY_100mS:	MOV	R7,#5
D100MS:		MOV	R6,#100
D200MS:		MOV	R5,#100
D300MS:		NOP
		NOP
		DJNZ	R5,D300MS
		DJNZ	R6,D200MS
		DJNZ	R7,D100MS
		RET

; ************************************************
;		DELAY   TWI
; ************************************************
DELAY_TWI:	MOV	R7,#9
D1TWI:		MOV	R6,#5
D2TWI:		NOP
		NOP	
		DJNZ	R6,D2TWI
		DJNZ	R7,D1TWI
		RET

DELAYS_TWI:	MOV	R7,#25
D1STWI:		MOV	R6,#20
D2STWI:		NOP
		NOP	
		DJNZ	R6,D2STWI
		DJNZ	R7,D1STWI
		RET

; ************************************************
;		DELAY  1s (AT 12CLK/MACHINE)
; ************************************************
DELAY_1S:	MOV	R7,#50
D1S:		MOV	R6,#100
D2S:		MOV	R5,#100
D3S:		NOP
		NOP
		DJNZ	R5,D3S
		DJNZ	R6,D2S
		DJNZ	R7,D1S
		RET

;*************************************************************
;		DELAY (100ms) & RX_A_KEY
;		OUTPUT: A
;*************************************************************
DELAY_RX_8574:	
		SETB	REN
		MOV	R7,#200	
DELAY_100MS_C:	MOV	R6,#200
DELAY_100MS_D:	NOP
		NOP
		DJNZ	R6,DELAY_100MS_D
		DJNZ	R7,DELAY_100MS_C
		CLR	RI
		MOV	A,SBUF
		RET

;*************************************************************
;		DELAY (100ms) & RX_A_KEY
;		OUTPUT: OUT_RX_DEL
;*************************************************************
DELAY_RX_L:	PUSH	ACC
		SETB	REN
		LCALL	DELAY_100MS
		CLR	RI
		MOV	A,SBUF
		MOV	OUT_RX_DEL,A
		POP	ACC
		RET

;*************************************************************
;		DELAY (--ms) & RX_A_KEY
;		OUTPUT: OUT_RX_DEL
;*************************************************************
DELAY_RX_LS:	PUSH	ACC
		SETB	REN
		LCALL	DELAY
		CLR	RI
		MOV	A,SBUF
		MOV	OUT_RX_DEL,A
		POP	ACC
		RET

; ************************************************
;		INTERRUPT SERVICE ROUTINE (TWI)
; ************************************************
TWI_IT:		PUSH	ACC
		MOV	ACC,TWI_DIR

		CJNE	A,#01H,NEXT_1
		POP	ACC
		LJMP	TWI_EEPROM

NEXT_1:		CJNE	A,#02H,NEXT_2
		POP	ACC
		LJMP	TWI_DS1307

NEXT_2:		CJNE	A,#03H,NEXT_3
		POP	ACC
		LJMP	TWI_PCF8574		

NEXT_3:		POP	ACC
		LJMP	MAIN_P

; ************* TWI status tasking ***************

TWI_EEPROM:	MOV	R7,SSCS	   
CASE_00:	CJNE	R7,#00h,CASE_08		; A start condition has been sent 
						; SLR+R/W are transmitted, ACK bit received
		CLR	B_TWI_BUSY		; TWI is free 
		ORL	SSCON,#10H		; SEND STOP
		LJMP	end_switch

CASE_08:	CJNE	R7,#08h,CASE_10		; A start condition has been sent
						; SLR+R/W are transmitted, ACK bit received  
		ANL	SSCON,#~20h		; clear start condition 

; 		send slave adress and read/write bit 

		MOV	ACC,slave_adr
		MOV	C,RW
		MOV	ACC.0,C
		MOV	SSDAT,ACC
		LJMP	end_switch
		
CASE_10:	CJNE	R7,#10h,CASE_18		; A repeated start condition has been sent
						; SLR+R/W are transmitted, ACK bit received
		ANL	SSCON,#~20h		; clear start condition 

;		send slave adress and read/write bit 

		MOV	ACC,slave_adr
		;=========
		SETB	RW
		;=========
		MOV	C,RW
		MOV	ACC.0,C
		MOV	SSDAT,ACC
		JMP	end_switch

CASE_18:	CJNE	R7,#18h,case_20		; SLR+W was transmitted, ACK bit received 
		MOV	N,#0FFH
		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ
		MOV	R1,DIRECTION
		CJNE	R1,#01H,RECEIVE_DIREC_18
		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ

		ANL	SSCON,#11110111B	; clear SI 
		MOV	SSDAT,ADR_H
CHECK_FIR:	MOV	ACC,SSCON
		JNB	ACC.3,CHECK_FIR		; JUMP IF SI = '0'

		ANL	SSCON,#11110111B	; clear SI 
		MOV	SSDAT,ADR_L
CHECK_SEC:	MOV	ACC,SSCON
		JNB	ACC.3,CHECK_SEC		; JUMP IF ACC.3 = '0'

		ANL	SSCON,#11110111B	; clear SI 
		MOV	SSDAT,TWI_data		; Transmit data byte, ACK bit received 
		JMP	end_switch

RECEIVE_DIREC_18:	
FIRST_D:	MOV	SSDAT,ADR_H
		ANL	SSCON,#11110111B	; clear SI
S18:		MOV	ACC,SSCON
		JNB	ACC.3,S18		; JUMP IF SI = '0'
	
		MOV	SSDAT,ADR_L
		LJMP	end_switch

CASE_20:	CJNE	R7,#20h,case_28		; SLR+W was transmitted, NOT ACK bit received 
		ORL	SSCON,#10h		; Transmit STOP
		CLR	b_TWI_busy		; TWI is free

		DJNZ	N,C_20
		CLR	CHECK_COM		; OUT OF TWI LOOP
		MOV	P1,#80H
C_20:		JMP	end_switch

CASE_28:	CJNE	R7,#28h,case_30		; DATA was transmitted, ACK bit received
		MOV	N,#0FFH

		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ
		MOV	R1,DIRECTION
		CJNE	R1,#01H,RECEIVE_DIREC_28
		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ

		;ANL	SSCON,#11110111B	; clear SI 
		ORL	SSCON,#10h		; send STOP 
		MOV	STOP_BACKUP,SSCON	; BACKUP
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switch

RECEIVE_DIREC_28:
		ORL	SSCON,#20h		; send start 
		JMP	end_switch

CASE_30:	CJNE	R7,#30h,case_38		; DATA was transmitted, NOT ACK bit received 
		ORL	SSCON,#10h		; Transmit STOP 
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switch

CASE_38:	CJNE	R7,#38h,case_40		; Arbitration lost in SLA+W or DATA. 
		ORL	SSCON,#10h		; Transmit STOP
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switch

CASE_40:	CJNE	R7,#40h,case_58		; As soon as, the DATA will move to SSDAT SFR.
		ANL	SSCON,#11110111B	; clear SI
S40:		MOV	ACC,SSCON
		JNB	ACC.3,S40		; JUMP IF SI = '0'
		MOV	TWI_DATA_I,SSDAT	; Master will send ACK or NACK to slave

		;================================
		;ORL SSCON,#00000100B		; set AA  */ SENT ACK
		ANL SSCON,#11111011B		; CLR AA  */ SENT NACK  ( DEFAULT USED )
		;================================
		LJMP	end_switch

CASE_58:	CJNE	R7,#58h,case_5X	
		ORL	SSCON,#00010000B	; send STOP 
		MOV	STOP_BACKUP,SSCON	; BACKUP
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switch

CASE_5X:
end_switch:	ANL	SSCON,#11110111B	; clear SI flag 
		RETI

; ************************************************
;		INTERRUPT SERVICE ROUTINE (DS1307)
; ************************************************
TWI_DS1307:	MOV	R7,SSCS

; ************* TWI status tasking ***************
   
CASE_00D:	CJNE	R7,#00h,CASE_08D		; A start condition has been sent 
						; SLR+R/W are transmitted, ACK bit received
		CLR	B_TWI_BUSY		; TWI is free 
		ORL	SSCON,#10H		; SEND STOP

		LJMP	end_switchD

CASE_08D:	CJNE	R7,#08h,CASE_10D	; A start condition has been sent
						; SLR+R/W are transmitted, ACK bit received  
		ANL	SSCON,#~20h		; clear start condition 

; 		send slave adress and read/write bit 

		MOV	ACC,slave_adr
		MOV	C,RW
		MOV	ACC.0,C
		MOV	SSDAT,ACC

		LJMP	end_switchD
		
CASE_10D:	CJNE	R7,#10h,CASE_18D	; A repeated start condition has been sent
						; SLR+R/W are transmitted, ACK bit received
		ANL	SSCON,#~20h		; clear start condition 

;		send slave adress and read/write bit 

		MOV	ACC,slave_adr
		;=========
		SETB	RW
		;=========
		MOV	C,RW
		MOV	ACC.0,C
		MOV	SSDAT,ACC
		JMP	end_switchD

CASE_18D:	CJNE	R7,#18h,case_20D	; SLR+W was transmitted, ACK bit received 
		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ
		MOV	R1,DIRECTION
		CJNE	R1,#01H,RECEIVE_DIREC_18D
		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ
		ANL	SSCON,#11110111B	; clear SI 
		MOV	SSDAT,ADR_L
CHECK_FIRD:	MOV	ACC,SSCON
		JNB	ACC.3,CHECK_FIRD	; JUMP IF SI = '0'

		ANL	SSCON,#11110111B	; clear SI 
		MOV	SSDAT,SEC		; Transmit data byte, ACK bit received 
		JMP	end_switchD

RECEIVE_DIREC_18D:
		MOV	SSDAT,ADR_L
		LJMP	end_switchD

CASE_20D:	CJNE	R7,#20h,case_28D		; SLR+W was transmitted, NOT ACK bit received 
		ORL	SSCON,#10h		; Transmit STOP
		CLR	b_TWI_busy		; TWI is free 
		JMP	end_switchD

CASE_28D:	CJNE	R7,#28h,case_30D		; DATA was transmitted, ACK bit received 

		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ
		MOV	R1,DIRECTION
		CJNE	R1,#01H,RECEIVE_DIREC_28D
		; JJJJJJJJJJJJJJJJJJJJJJJJJJJJ

		ORL	SSCON,#10h		; send STOP 
		MOV	STOP_BACKUP,SSCON	; BACKUP
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switchD
RECEIVE_DIREC_28D:
		ORL	SSCON,#20h		; send start 
		JMP	end_switchD

CASE_30D:	CJNE	R7,#30h,case_38D		; DATA was transmitted, NOT ACK bit received 
		ORL	SSCON,#10h		; Transmit STOP 
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switchD

CASE_38D:	CJNE	R7,#38h,case_40D		; Arbitration lost in SLA+W or DATA. 
		ORL	SSCON,#10h		; Transmit STOP
		CLR	b_TWI_busy		; TWI is free 
		JMP	end_switchD

CASE_40D:	CJNE	R7,#40h,case_58D		; As soon as, the DATA will move to SSDAT SFR.
		ANL	SSCON,#11110111B	; clear SI
S40D:		MOV	ACC,SSCON
		JNB	ACC.3,S40D		; JUMP IF SI = '0'
		MOV	SEC_R,SSDAT	; Master will send ACK or NACK to slave

		;================================
		;ORL SSCON,#00000100B		; set AA  */ SENT ACK
		ANL SSCON,#11111011B		; CLR AA  */ SENT NACK  ( DEFAULT USED )
		;================================

		LJMP	end_switchD

CASE_58D:	CJNE	R7,#58h,case_5XD	
		ORL	SSCON,#00010000B	; send STOP 
		MOV	STOP_BACKUP,SSCON	; BACKUP
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switchD

CASE_5XD:
end_switchD:	ANL	SSCON,#11110111B	; clear SI flag 
		RETI

; ************************************************
;		INTERRUPT SERVICE ROUTINE
; ************************************************
TWI_PCF8574:	MOV	R7,SSCS

; ************* TWI status tasking ***************
   
CASE_00_PCF:	CJNE	R7,#00h,CASE_08_PCF		; A start condition has been sent 
						; SLR+R/W are transmitted, ACK bit received
		CLR	B_TWI_BUSY		; TWI is free 
		ORL	SSCON,#10H		; SEND STOP
		LJMP	end_switch_PCF

CASE_08_PCF:	CJNE	R7,#08h,CASE_10_PCF		; A start condition has been sent
						; SLR+R/W are transmitted, ACK bit received  
		ANL	SSCON,#~20h		; clear start condition 

; 		send slave adress and read/write bit 

		MOV	ACC,slave_adr
		MOV	C,RW
		MOV	ACC.0,C
		MOV	SSDAT,ACC
		LJMP	end_switch_PCF
		
CASE_10_PCF:	CJNE	R7,#10h,CASE_18_PCF		; A repeated start condition has been sent
						; SLR+R/W are transmitted, ACK bit received
		ANL	SSCON,#~20h		; clear start condition 

;		send slave adress and read/write bit 

		MOV	ACC,slave_adr
		;=========
		SETB	RW
		;=========
		MOV	C,RW
		MOV	ACC.0,C
		MOV	SSDAT,ACC
		JMP	end_switch_PCF

CASE_18_PCF:	CJNE	R7,#18h,case_20_PCF		; SLR+W was transmitted, ACK bit received 

		ANL	SSCON,#11110111B	; clear SI 
		MOV	SSDAT,TWI_data		; Transmit data byte, ACK bit received 
		JMP	end_switch_PCF

CASE_20_PCF:	CJNE	R7,#20h,case_28_PCF		; SLR+W was transmitted, NOT ACK bit received 
		ORL	SSCON,#10h		; Transmit STOP
		CLR	b_TWI_busy		; TWI is free 
		JMP	end_switch_PCF

CASE_28_PCF:	CJNE	R7,#28h,case_5X_PCF			; DATA was transmitted, ACK bit received
		;ANL	SSCON,#11110111B	; clear SI 
		ORL	SSCON,#10h		; send STOP 
		MOV	STOP_BACKUP,SSCON	; BACKUP
		CLR	b_TWI_busy		; TWI is free
		JMP	end_switch_PCF

CASE_5X_PCF:
end_switch_PCF:	ANL	SSCON,#11110111B	; clear SI flag 
		RETI
; ************************************************
;		MESSAGE  
; ************************************************
; ************************************************
TEXT_ERR1:	DFB "I'm sorry. Press any key again,sir.",0FFH

; ************************************************
TEXT_1:		DFB	0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	"This is the TEST Software for CP-JR51USB v1.0",0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	"Please,Press 'Enter key' to continue."	,0FFH

; ************************************************
TEXT_2:		DFB 0AH,0DH
		DFB "Mr. Jakkapan Jitsup",0AH,0DH,0FFH

; ************************************************
TEXT_INT0:	
		DFB "[ OK ]",0FFH

; ************************************************
;		PAGE 1
; ************************************************
PAGE_1:		DFB	0AH,0AH,0AH,0DH		; 3 LINE AND RETURN KEY
		DFB	09H,09H			; 2 TAB
		DFB	0C9H,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH
		DFB	0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0BBH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"					",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  Product name	: CP-JR51USB v1.0	",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  Support	: AT89C5131		",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  X'TAL	: 24MHz			",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  Company	: ETT.CO.,LTD		",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  Writer	: Mr. Jakkapan Jitsup	",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"					",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0C8H,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH
		DFB	0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0BCH,0AH,0DH,0FFh

; ************************************************
;		PAGE 2
; ************************************************
PAGE_2:		DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H			; 2 TAB
		DFB	0C9H,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH
		DFB	0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0BBH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"		MAIN MENU		",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0CCH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH
		DFB	0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0B9H,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  1.] PORT 0				",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  2.] PORT 1				",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  3.] PORT 2				",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  4.] PORT 3				",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  5.] INT 0 (SWITCH)			",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  6.] EEPROM (24XX256)			",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  7.] DS1307				",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0BAH,	"  8.] PORT I2C BUS [PCF8574]		",0BAH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0C8H,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH
		DFB	0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0CDH,0BCH,0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	"[Please, select this choose or press ESC key to back.]",0AH,0DH
		DFB	09H,09H			; 2 TAB
		DFB	0FFH

; ************************************************
;		PAGE PORT 0
; ************************************************		
PAGE_PORT0:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$    PORT0 MENU    $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Ensure the Hardware is connected on PORT 0.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* If the connection is successful,the LED on Hardware are rotating.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Press 'ESC' to Back."
		DFB	0FFH

; ************************************************
;		PAGE PORT 1
; ************************************************		
PAGE_PORT1:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$    PORT1 MENU    $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Ensure the Hardware is connected on PORT 1.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* If the connection is successful,the LED on Hardware are rotating.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Press 'ESC' to Back."
		DFB	0FFH

; ************************************************
;		PAGE PORT 2
; ************************************************		
PAGE_PORT2:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$    PORT2 MENU    $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Ensure the Hardware is connected on PORT 2.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* If the connection is successful,the LED on Hardware are rotating.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Press 'ESC' to Back."
		DFB	0FFH

; ************************************************
;		PAGE PORT 3
; ************************************************		
PAGE_PORT3:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$    PORT3 MENU    $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Ensure the Hardware is connected on PORT 3 (P3.2 - P3.7 Only).",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* If the connection is successful,the LED on Hardware are rotating.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Press 'ESC' to Back."
		DFB	0FFH

; ************************************************
;		PAGE INT0
; ************************************************		
PAGE_INT0:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$    INT 0 MENU    $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Click the INT0 button of the CP-JR51USB v1.0 board.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* If the connection is successful,the message ' [OK] '",0AH,0DH   
		DFB	09H			; 1 TAB
		DFB	"  is displayed below on this window.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	"* Press 'ESC' to Back.",0AH,0AH,0DH
		DFB	09H			; 1 TAB
		DFB	" :"
		DFB	0FFH

; ************************************************
;		PAGE EEPROM
; ************************************************		
PAGE_EEPROM:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$    EEPROM MENU   $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0DH
		DFB	0FFH
;-------------------------------------------------
;----------------------------------------------------------------------------------
SHOW1:		DFB	"TEST 24XX256 RANGE 00H - 0FFH",00AH,00DH,00AH,00DH,0FFH
			
;----------------------------------------------------------------------------------
SHOW_ERR_TWI:	DFB	"DETECTION'S ERROR :",00AH,00DH,00AH,00DH
		DFB	"THERE ARE SOME PROBLEMs ABOUT COMMUNICATION.",00AH,00DH
		DFB	"ARE YOU SURE TO CONNECT A 24LC256 CHIP ON SOCKET ?",00AH,00DH,00AH,00DH
		DFB	"PLEASE, PRESS 'ESC' TO BACK.",00AH,00DH
		DFB	0FFH
;----------------------------------------------------------------------------------
SHOW_ENTER:		DFB	"ENTER",0FFH

;----------------------------------------------------------------------------------
SHOW2:		DFB	"RESULT OF COMPARED : .............",0FFH
			
;----------------------------------------------------------------------------------
SHOW_OK:	DFB	"[ OK ]",0FFH
			
;----------------------------------------------------------------------------------
SHOW_FAIL:	DFB	"[ FAIL ]",0FFH
					
; ************************************************
;		PAGE DS1307
; ************************************************		
PAGE_DS1307:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$    DS1307 MENU   $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0AH,0DH
		DFB	09H,09H,09H,09H		; 4 TAB
		DFB	0FFH

; ************************************************
;		PAGE PCF8574
; ************************************************		
PAGE_PCF8574:	DFB	0AH,0AH,0DH		; 2 LINE AND RETURN KEY
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$   PCF8574A MENU  $",0AH,0DH
		DFB	09H,09H,09H		; 3 TAB
		DFB	"$$$$$$$$$$$$$$$$$$$$",0AH,0AH,0AH,0AH,0DH
		DFB	"ARE YOU SURE TO CONNECT A PCF8574A CHIP ON I2C BUS ?",00AH,00DH,00AH,00DH
		DFB	"YOU CAN SEE RESULT ON I2C PORT.",00AH,00DH,00AH,00DH
		DFB	"PLEASE, PRESS 'ESC' TO BACK.",00AH,00DH
		DFB	0FFH

		END